 Chap. 7        Problem Solving                                                 CMD 

                            ^b  Problem Solving  



    This section explains system troubleshooting. If the remedy involves
    opening the system top cover, send the system for repair.


                    Solving System Problems

    Computer problems are usually caused by hardware, software, or both.
    Effective troubleshooting requires that you (1) list down the symptoms,
    and (2) localize the problem. Some problems may require the technical
    assistance of your dealer. Before calling for service, check for possible
    solutions in this section.


  ^bA. Initial System Power-On Problems

     If you are having power-on problems, be sure that the system is connected
     to a properly grounded electrical outlet and all other peripheral
     devices are connected to the system.


  ^bB. Power-On Self Test (POST)

     POST is a series of checks the system performs during power-on to
     verify proper operation of the system. After a successful POST, the
     system prompt is shown. POST does not test all areas, only those that
     allow the system to be operational.


     Two kinds of errors may be detected during POST: critical (fatal) and
     non-critical errors. If the error is fatal, the system halts and cannot
     operate at all. Non-critical errors are those that cause incorrect results
     , which may not be apparent to the user. If the error is non-critical, the
     system continues after reporting the error. An example of a non-critical
     error would be a memory chip failure.

     Whenever an error is encountered, you either hear a few short beeps
     or see an error message.

        Beep Count   Meaning

        1            DRAM refrsh failure

        2            Conventional and extended test failure

        3            Base 64 KB RAM failure

        4            System timer failure

        5            Processor failure

        6            Keyboard controller - Gate A20 error

        7            Virtual mode exception error

        8            Display vertical and horizontal retrace test failured

        9            ROM-BIOS checksum failure




     In such cases, proceed as follows:

       i.    Record any error messages and beep patterns.

       ii.   Refer to the following sections for corrective action.

       iii.  Restart the system.

       iv.   If the same error message(s) and beep pattern occur, contact
             your dealer.



  ^bC. System Startup Problems

     a. System does not beep when powered on.

     b. Listen and determine if the fan is running. If the fan
        is not operating, check that the power cord is connected to a live
        power outlet and to the system. If your system does not work, take
        it to your dealer or an authorized service center to have the power
        supply checked.

     c. System beeps, but no cursor appears on the monitor.

        Be sure the brightness control is adjusted properly. If
        this is the first time this system configuration is booted, make sure
        you are using the correct switch setting for the video adapter type.
        It should match your built-in VGA.

              System displays , MEM ERROR or PARITY CHECK.

        Take your system to your dealer or an authorized service center
        to have its RAM chips checked if memory problems are indicated.

     d. System beeps, the cursor blinks on the monitor, but the
        FDD light does not go on.

        If your floppy controller cable is in place, take your
        system to the dealer or an authorized service center to have its
        controller card and floppy disk drive checked.


     e. System beeps twice (or more), and monitor screen is blank.
        Send the system unit for repair.

     f. System beeps, the FDD light goes on, but one of the following
        error messages appear:


        1. Disk Error
           This message indicates that no boot sector can be read. The
           reason is either no disk was inserted in the drive, the disk was
           not readable, or the disk drive lever has not been turned down.

        2. Disk Boot Failure
           This message is displayed when one or both of the DOS
           hidden system files is missing from the diskette.

        3. Bad or Missing Command Interpreter
           This error message represents a corrupt or missing COMMAND.COM
           on the diskette. In either case, attempt to boot again by pressing
           <Enter>. Repeat the boot operation with another copy of the
           system diskette. If the error persists, take your system to the
           dealer or an authorized service center.


     g. Hard Disk Drive Problems

        1.System no longer boots from the hard disk drive even
          though the drive light is lit.

          Boot your system from drive A using a bootable diskette.
          Then try to read the directory on the hard disk by typing DIR C:.
          If you can read the hard disk directory, reinstall the system onto
          drive C by typing SYS C:, then press <Enter>.

          If this does not make the system bootable, back up any
          files that are not already backed up, and reinstall DOS on your
          hard disk through the use of FORMAT and COPY. Detailed instructions
          for installing DOS on your hard disk can be found in your DOS
          Manual. RESTORE your files to the hard disk from your most recent
          backup.

        2.System does not boot from the hard disk and you cannot
          read a directory or files from it when booted from the floppy disk.

          Reinstall DOS on your hard disk through the use of FORMAT and
          COPY. RESTORE your files to the hard disk from the most recent backup.

          If your hard disk cannot be formatted, take your system to your dealer
          or an authorized service center to have the hard disk drive checked.


     h. Problems With a Diskette Drive

        1.Diskette drive in-use light stays on.

          If there is a diskette in the drive, check to see that:

          .The diskette is not damaged and is inserted correctly label up and
           metal-shutter end first. Try another diskette.

          .Your software program is okay.

          If the problem persists, have the system unit serviced.

        2.Drive doesn't respond to boot command (diskette drive in-use light
          doesn't come on).

          Check to see that:

          .  Disk drive cable is not defective (broken conductors)
             and is securely plugged in. If defective, replace cable.

          .  Power supply cable is securely connected in the power
             case on the diskette drive.

          If none of these is the cause, the FDC board or diskette
          drive logic board may be defective. Send the system for repair.


          Problems with inserting or removing diskettes may be due to:

          .  Write-protect or other label stuck somewhere in disk pathway;
             or drive hub gummed up with adhesive from hub rings. Remove
             and clean off adhesive from drive hub with lint-free cloth
             moistened with lighter fluid.

          Drive head was not released from loaded position. Close the
          drive latch and release again (for 5 1/4" drive). If this
          does not work, insert a scratch disk and reset the system. If
          problem persists, send the system for repair.

        4.Diskette drive in-use light turns on when boot command
          is given but disk will not boot.

          Check the boot diskette. If error persists, send the system
          for repair.


     i. Problems When Running a New Program

        1.Application program is not running correctly.

          Your computer must have the minimum memory space requirements to
          use the software. Refer to the software manuals for verification.
          If necessary, delete unnecessary files to accommodate the software
          and reinstall the application program.


        2.System halts or an NMI error occurs.

          A hardware-software incompatibility may cause the system
          to stop execution. This condition occurs when:

          .The serial and parallel port on the system board uses the same
           address as the serial/parallel port of an adapter card. Change
           the serial/parallel port address of the adapter card.

          .You specified the wrong type of printer for your application
           program. Reinstall the application program with the correct
           printer.


          If these solutions do not work, the software may have
          been designed for a different type of computer.

          The system may halt when there is a component (memory IC) defect.
          Turn off the system, then turn on again after a few seconds. Execute
          the diagnostics program to check the cause. If the problem persists,
          contact your dealer.



     j. Problems After the System and Software are Running Correctly

        1.If you receive error messages when using a software program,
          refer to the manuals supplied with the software for a description
          of the messages and solutions to the problem.

        2.The screen shows random  " garbage " (meaningless jumble of
          characters).

          The diskette has some damaged sectors, the file is damaged,
          or the file is not a readable text file.



     k. Problems with Peripheral Devices and Other Components

        1.All or some keys on the keyboard do not work.
          If the testing programs on the diagnostics program cannot
          find the problem, have the system serviced.


        2.The mouse or pointing device does not work.
          Check the instructions supplied with the mouse or pointing device
          for additional testing information. If no testing information
          is available, have the mouse or pointing device serviced.


        3.External 5 1/4" floppy disk drive does not work.
          Check if all settings are correct and the cables are properly
          connected. If problem persists, consult your dealer.


        4.The printer does not work.
          Check that the printer is turned on and is ON-LINE.
          Check that the printer signal cable is properly connected
          to the system unit.

